<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bloque extends Model 
{

    protected $table = 'bloques';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'active');
    protected $visible = array('name', 'active');

    public function bloques_peliculas()
    {
        return $this->hasMany('BloquePelicula', 'bloque_id');
    }

}